package ru.yandex.direct.dssclient.pdfstamp;

import com.google.common.collect.ImmutableMap;

public class Color {
    private final int red;
    private final int green;
    private final int blue;

    public Color(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public int getRed() {
        return red;
    }

    public int getGreen() {
        return green;
    }

    public int getBlue() {
        return blue;
    }

    public Object toJsonObject() {
        return ImmutableMap.<String, Object>builder()
                .put("Red", red)
                .put("Green", green)
                .put("Blue", blue)
                .build();
    }
}
