package ru.yandex.direct.dssclient.pdfstamp;

import java.util.Set;

import com.google.common.collect.ImmutableMap;

import static java.util.Collections.emptySet;

public class Font {
    public static final Font DEFAULT = new Font(8, emptySet(), Family.TIMES, Colors.BLACK);

    private final int size;
    private final Set<Style> styles;
    private final Family family;
    private final Color color;

    public enum Style {
        BOLD(1),
        ITALIC(2),
        UNDERLINE(4),
        STRIKETHROUGH(8);

        private final int value;

        Style(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }
    }

    public enum Family {
        TIMES("times"),
        ARIAL("arial");

        private final String value;

        Family(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

    public Font(int size, Set<Style> styles, Family family, Color color) {
        this.size = size;
        this.styles = styles;
        this.family = family;
        this.color = color;
    }

    public int getSize() {
        return size;
    }

    public Set<Style> getStyles() {
        return styles;
    }

    public Family getFamily() {
        return family;
    }

    public Color getColor() {
        return color;
    }

    public Object toJsonObject() {
        return ImmutableMap.<String, Object>builder()
                .put("FontSize", size)
                .put("FontFamily", family.getValue())
                .put("FontStyle", styles.stream().map(Style::getValue).reduce(0, (a, b) -> a | b))
                .put("FontColor", color.toJsonObject())
                .build();
    }

}
