package ru.yandex.direct.dssclient.pdfstamp;

import com.google.common.collect.ImmutableMap;

public class Icon {
    public static final int DEFAULT_SCALE = 100;

    private final int horizontalPosition;
    private final int verticalPosition;
    private final Image image;
    private final int scale;

    public Icon(Image image) {
        this(0, 0, image, DEFAULT_SCALE);
    }

    public Icon(byte[] imageContent) {
        this(new Image(imageContent));
    }

    public Icon(int horizontalPosition, int verticalPosition, Image image, int scale) {
        this.horizontalPosition = horizontalPosition;
        this.verticalPosition = verticalPosition;
        this.image = image;
        this.scale = scale;
    }

    public int getHorizontalPosition() {
        return horizontalPosition;
    }

    public int getVerticalPosition() {
        return verticalPosition;
    }

    public Image getImage() {
        return image;
    }

    public int getScale() {
        return scale;
    }

    public Object toJsonObject() {
        return ImmutableMap.<String, Object>builder()
                .put("Image", image.getContentBase64())
                .put("LowerLeftX", horizontalPosition)
                .put("LowerLeftY", verticalPosition)
                .put("Scale", scale)
                .build();
    }

}
