package ru.yandex.direct.dssclient.pdfstamp;

import java.util.Base64;

import com.google.common.collect.ImmutableMap;

public class Image {
    private final String contentBase64;

    public Image(byte[] content) {
        this.contentBase64 = Base64.getEncoder().encodeToString(content);
    }

    public String getContentBase64() {
        return contentBase64;
    }

    public Object toJsonObject() {
        return ImmutableMap.of("Image", contentBase64);
    }
}
