package ru.yandex.direct.dssclient.pdfstamp;

import com.google.common.collect.ImmutableMap;

public class Text {
    private final Font font;
    private final String value;
    private final int leftMargin;

    public Text(String value) {
        this(Font.DEFAULT, value, 0);
    }

    public Text(Font font, String value, int leftMargin) {
        this.font = font;
        this.value = value;
        this.leftMargin = leftMargin;
    }

    public Font getFont() {
        return font;
    }

    public String getValue() {
        return value;
    }

    public int getLeftMargin() {
        return leftMargin;
    }

    public Object toJsonObject() {
        return ImmutableMap.<String, Object>builder()
                .put("Text", value)
                .put("Font", font.toJsonObject())
                .put("Margin", leftMargin)
                .build();
    }
}
