package ru.yandex.direct.excelmapper;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;


@ParametersAreNonnullByDefault
public interface ExcelMapper<T> {

    MapperMeta getMeta();

    default boolean canBeEmpty() {
        return false;
    }

    /**
     * Возвращает кол-во записанных строк
     */
    int write(SheetRange sheetRange, @Nullable T value);

    ReadResult<T> read(SheetRange sheetRange);

    boolean canStartReading(SheetRange sheetRange);
}
