package ru.yandex.direct.excelmapper;

import javax.annotation.Nullable;

import static com.google.common.base.Preconditions.checkNotNull;

public class Height {
    private static final Height DYNAMIC_HEIGHT = new Height(null);

    @Nullable
    private final Integer value; // null, если высота динамическая

    private Height(@Nullable Integer value) {
        this.value = value;
    }

    public static Height fixed(int height) {
        return new Height(height);
    }

    public static Height dynamic() {
        return DYNAMIC_HEIGHT;
    }

    public boolean isFixed() {
        return value != null;
    }

    public boolean isDynamic() {
        return value == null;
    }

    public int getValue() {
        return checkNotNull(value);
    }
}
