package ru.yandex.direct.excelmapper;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public class MapperMeta {
    /**
     * Названия колонок
     */
    private final List<String> columns;
    /**
     * Кол-во строк которые пишутся/читаются маппером, или же указание, что кол-во строк динамическое -- зависит от значения
     */
    private final Height height;
    /**
     * Обязательные колонки для заполнения
     */
    private final Set<String> requiredColumns;

    public MapperMeta(List<String> columns, Height height, Set<String> requiredColumns) {
        this.columns = checkNotNull(columns);
        this.height = checkNotNull(height);
        this.requiredColumns = checkNotNull(requiredColumns);
    }

    public List<String> getColumns() {
        return columns;
    }

    public Height getHeight() {
        return height;
    }

    public int getWidth() {
        return columns.size();
    }

    public Set<String> getRequiredColumns() {
        return requiredColumns;
    }
}
