package ru.yandex.direct.excelmapper;

import java.util.List;
import java.util.Set;

import org.apache.poi.ss.usermodel.Cell;

public interface SheetRange {
    int getHeight();

    SheetRange makeSubRange(int offsetRows, int offsetCols);

    SheetRange makeSubRange(int offsetRows, int offsetCols, int subRangeHeight);

    SheetRange makeSubRange(int offsetRows, int offsetCols, HeightMode heightMode);

    boolean isOffsetRowsInRange(int offsetRows);

    Cell getCell(int row, int col);

    /**
     * Метод возвращает ячейку, так же как и {@link #getCell(int, int)}, но используется тогда, когда предполагается,
     * что значение ячейки будет изменено. Нужно для метода {@link #getColumnsWithNotEmptyValue()},
     * возвращающего множество измененных колонок
     */
    Cell getCellForWrite(int row, int col);

    /**
     * Получить множество колонок в ячейках которых были изменены данные (получение ячейки через
     * {@link #getCellForWrite})
     * Так же учитываются колонки в подучастках, созданных через {@link #makeSubRange}
     */
    Set<Integer> getColumnsWithNotEmptyValue();

    void reportInvalidCellDataFormat(List<String> columns, int offsetRows, int offsetCols);

    void reportCantReadEmpty(List<String> columns, int offsetRows, int offsetCols);

    void reportCantReadFormat(List<String> columns, int offsetRows, int offsetCols);

    void reportCantReadRangeMismatch(List<String> columns, int offsetRows, int offsetCols);

    void reportCantReadUnexpectedData(List<String> columns, int offsetRows, int offsetCols);

    enum HeightMode {
        AUTODETECT_HEIGHT,
        MAX_HEIGHT
    }
}
