package ru.yandex.direct.excelmapper.exceptions;

import java.util.List;

import static com.google.common.base.Preconditions.checkArgument;

public class ExcelMapperException extends RuntimeException {
    protected final List<String> columns;

    public ExcelMapperException(List<String> columns) {
        checkArgument(!columns.isEmpty());
        this.columns = columns;
    }

    public List<String> getColumns() {
        return columns;
    }
}
