package ru.yandex.direct.excelmapper.exceptions;

import java.util.List;

abstract public class ExcelMapperReadException extends ExcelMapperException {
    protected final int rowIndex;
    protected final int columnIndex;

    public ExcelMapperReadException(List<String> columns, int rowIndex, int columnIndex) {
        super(columns);
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
    }

    public int getRowIndex() {
        return rowIndex;
    }

    public int getColumnIndex() {
        return columnIndex;
    }
}
