package ru.yandex.direct.excelmapper.mappers;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.excelmapper.SheetRange;

@ParametersAreNonnullByDefault
public class EnumExcelMapper<T extends Enum<T>> extends AbstractSimpleTypeExcelMapper<T> {

    private final Function<T, String> writeMapper;
    private final Function<String, T> readMapper;

    public EnumExcelMapper(String title, Class<T> enumClass) {
        this(title, T::name, value -> T.valueOf(enumClass, value.toUpperCase()));
    }

    public EnumExcelMapper(String title, Function<T, String> writeMapper, Function<String, T> readMapper) {
        super(title);
        this.writeMapper = writeMapper;
        this.readMapper = readMapper;
    }

    @Override
    protected String convertValueToWrite(T value) {
        return writeMapper.apply(value);
    }

    @Override
    protected T convertValueToRead(String stringCellValue, SheetRange sheetRange) {
        try {
            return readMapper.apply(stringCellValue);
        } catch (IllegalArgumentException ignore) {
            sheetRange.reportCantReadFormat(getMeta().getColumns(), ROW, COL);
        }
        // недостижимое место
        throw new IllegalStateException();
    }

}
