package ru.yandex.direct.excelmapper.mappers;

import javax.annotation.Nullable;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.excelmapper.exceptions.InvalidCellDataFormatException;

/**
 * Маппер для гиперссылок.
 * */
public class HyperlinkExcelMapper extends AbstractFormulaExcelMapper<String> {

    private static final String HYPERLINK_OPEN = "HYPERLINK(";
    private static final String HYPERLINK_CLOSE = ")";
    private static final String SEPARATOR = ",";
    private static final int PART_NUMBER = 5;
    private static final int HYPERLINK_OPEN_PART_INDEX = 0;
    private static final int URL_PART_INDEX = 1;
    private static final int SEPARATOR_PART_INDEX = 2;
    private static final int TITLE_PART_INDEX = 3;
    private static final int HYPERLINK_CLOSE_PART_INDEX = 4;

    private static final String QUOTE = "\"";

    public HyperlinkExcelMapper(String title) {
        super(title);
    }

    @Override
    protected String convertValueToWrite(String value) {
        return value;
    }

    @Override
    protected String convertValueToRead(String stringCellValue) {
        if (!checkIfValueIsHyperlink(stringCellValue)) {
            throw new InvalidCellDataFormatException(getMeta().getColumns(), ROW, COL);
        }

        return stringCellValue;
    }

    protected static boolean checkIfValueIsHyperlink(String value) {
        String[] parts = value.split(QUOTE);
        return (parts.length == PART_NUMBER
                && parts[HYPERLINK_OPEN_PART_INDEX].equals(HYPERLINK_OPEN)
                && parts[HYPERLINK_CLOSE_PART_INDEX].equals(HYPERLINK_CLOSE)
                && parts[SEPARATOR_PART_INDEX].equals(SEPARATOR)
        );
    }

    public static String makeHyperlink(String url, String title) {
        return HYPERLINK_OPEN
                + QUOTE + url + QUOTE
                + SEPARATOR
                + QUOTE + title + QUOTE
                + HYPERLINK_CLOSE;
    }

    @Nullable
    public static Pair<String, String> getLinkAndTitle(String value) {
        if (!checkIfValueIsHyperlink(value)) {
            return null;
        }
        String[] parts = value.split(QUOTE);
        return Pair.of(parts[URL_PART_INDEX], parts[TITLE_PART_INDEX]);
    }
}
