package ru.yandex.direct.excelmapper.mappers;

/**
 * Маппер для гиперссылок и строк.
 * */
public class HyperlinkOrStringMapper extends AbstractSingleCellMapper<String> {

    public HyperlinkOrStringMapper(String title) {
        super(title);
    }

    @Override
    protected String convertValueToWrite(String value) {
        return value;
    }

    @Override
    protected String convertValueToRead(String stringCellValue) {
        return stringCellValue;
    }

    @Override
    protected boolean isFormula(String value) {
        return isHyperlink(value);
    }

    protected static boolean isHyperlink(String value) {
        return HyperlinkExcelMapper.checkIfValueIsHyperlink(value);
    }
}
