package ru.yandex.direct.excelmapper.mappers;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.excelmapper.SheetRange;

@ParametersAreNonnullByDefault
public class IntegerExcelMapper extends AbstractSimpleTypeExcelMapper<Integer> {

    public IntegerExcelMapper(String title) {
        super(title);
    }

    @Override
    protected String convertValueToWrite(Integer value) {
        return value.toString();
    }

    @Override
    protected Integer convertValueToRead(String stringCellValue, SheetRange sheetRange) {
        try {
            return Integer.valueOf(stringCellValue);
        } catch (NumberFormatException ignore) {
            sheetRange.reportCantReadFormat(getMeta().getColumns(), ROW, COL);
        }
        // недостижимое место
        throw new IllegalStateException();
    }

}
