package ru.yandex.direct.excelmapper.mappers;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.excelmapper.SheetRange;

@ParametersAreNonnullByDefault
public class IntegerZeroToNullExcelMapper extends IntegerExcelMapper {

    public IntegerZeroToNullExcelMapper(String title) {
        super(title);
    }

    @Override
    protected Integer convertValueToRead(String stringCellValue, SheetRange sheetRange) {
        var value = super.convertValueToRead(stringCellValue, sheetRange);
        return value == 0 ? null : value;
    }

}

