package ru.yandex.direct.excelmapper.mappers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.excelmapper.SheetRange;

@ParametersAreNonnullByDefault
public class LocalDateMapper extends AbstractSimpleTypeExcelMapper<LocalDate> {

    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public LocalDateMapper(String title) {
        super(title);
    }

    @Override
    protected String convertValueToWrite(LocalDate value) {
        return value.format(DATE_TIME_FORMATTER);
    }

    @Override
    protected LocalDate convertValueToRead(String stringCellValue, SheetRange sheetRange) {
        try {
            return LocalDate.parse(stringCellValue, DATE_TIME_FORMATTER);
        } catch (DateTimeParseException ignore) {
            sheetRange.reportCantReadFormat(getMeta().getColumns(), ROW, COL);
        }
        // недостижимое место
        throw new IllegalStateException();
    }

}
