package ru.yandex.direct.excelmapper.mappers;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.excelmapper.SheetRange;

@ParametersAreNonnullByDefault
public class LocalDateTimeMapper extends AbstractSimpleTypeExcelMapper<LocalDateTime> {

    private static final DateTimeFormatter LOCAL_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");

    public LocalDateTimeMapper(String title) {
        super(title);
    }

    @Override
    protected String convertValueToWrite(LocalDateTime value) {
        return value.format(LOCAL_DATE_TIME_FORMATTER);
    }

    @Override
    protected LocalDateTime convertValueToRead(String stringCellValue, SheetRange sheetRange) {
        try {
            return LocalDateTime.parse(stringCellValue, LOCAL_DATE_TIME_FORMATTER);
        } catch (DateTimeParseException ignore) {
            sheetRange.reportCantReadFormat(getMeta().getColumns(), ROW, COL);
        }
        // недостижимое место
        throw new IllegalStateException();
    }

}
