package ru.yandex.direct.excelmapper.mappers;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.excelmapper.SheetRange;

@ParametersAreNonnullByDefault
public class LongExcelMapper extends AbstractSimpleTypeExcelMapper<Long> {

    public LongExcelMapper(String title) {
        super(title);
    }

    @Override
    protected String convertValueToWrite(Long value) {
        return value.toString();
    }

    @Override
    protected Long convertValueToRead(String stringCellValue, SheetRange sheetRange) {
        try {
            return Long.valueOf(stringCellValue);
        } catch (NumberFormatException ignore) {
            sheetRange.reportCantReadFormat(getMeta().getColumns(), ROW, COL);
        }
        // недостижимое место
        throw new IllegalStateException();
    }

}
