package ru.yandex.direct.excelmapper.mappers;

import java.util.function.Predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.excelmapper.ExcelMapper;
import ru.yandex.direct.excelmapper.MapperMeta;
import ru.yandex.direct.excelmapper.ReadResult;
import ru.yandex.direct.excelmapper.SheetRange;

@ParametersAreNonnullByDefault
public class PredicateCheckingExcelMapper<T> implements ExcelMapper<T> {
    private final ExcelMapper<T> innerMapper;
    private final Predicate<T> predicate;

    public PredicateCheckingExcelMapper(ExcelMapper<T> innerMapper, Predicate<T> predicate) {
        this.innerMapper = innerMapper;
        this.predicate = predicate;
    }

    @Override
    public MapperMeta getMeta() {
        return innerMapper.getMeta();
    }

    @Override
    public int write(SheetRange sheetRange, @Nullable T value) {
        return innerMapper.write(sheetRange, value);
    }

    @Override
    public ReadResult<T> read(SheetRange sheetRange) {
        var result = innerMapper.read(sheetRange);
        if (!predicate.test(result.getValue())) {
            sheetRange.reportCantReadFormat(getMeta().getColumns(), 0, 0);
        }
        return result;
    }

    @Override
    public boolean canStartReading(SheetRange sheetRange) {
        return innerMapper.canStartReading(sheetRange);
    }
}
