package ru.yandex.direct.excelmapper.mappers;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.excelmapper.SheetRange;

/**
 * Маппер для булевых значений, которые меняем на Да/Нет
 * При чтении делается регистронезависимая проверка значения на Да/Нет
 */
@ParametersAreNonnullByDefault
public class YesNoBooleanExcelMapper extends AbstractSimpleTypeExcelMapper<Boolean> {

    private static final String YES = "Да";
    private static final String NO = "Нет";

    public YesNoBooleanExcelMapper(String title) {
        super(title);
    }

    @Override
    protected String convertValueToWrite(Boolean value) {
        return booleanToString(value);
    }

    @Override
    protected Boolean convertValueToRead(String stringCellValue, SheetRange sheetRange) {
        if (YES.equalsIgnoreCase(stringCellValue)) {
            return true;
        } else if (NO.equalsIgnoreCase(stringCellValue)) {
            return false;
        } else {
            sheetRange.reportCantReadFormat(getMeta().getColumns(), ROW, COL);
        }
        // недостижимое место
        throw new IllegalStateException();
    }

    public static String booleanToString(boolean value) {
        return value ? YES : NO;
    }

}
