package ru.yandex.direct.expert.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.expert.client.model.Certificate;
import ru.yandex.direct.expert.client.model.FindByUidsRequest;
import ru.yandex.direct.http.smart.core.Smart;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors;

public class ExpertClient {
    private final Api api;

    public ExpertClient(String url, TvmService tvmService, ParallelFetcherFactory parallelFetcherFactory,
                        TvmIntegration tvmIntegration) {
        api = createApi(url, tvmService, parallelFetcherFactory, tvmIntegration);
    }

    private Api createApi(String url, TvmService tvmService, ParallelFetcherFactory parallelFetcherFactory,
                          TvmIntegration tvmIntegration) {
        return Smart.builder()
                .withParallelFetcherFactory(parallelFetcherFactory)
                .useTvm(tvmIntegration, tvmService)
                .withProfileName("expert_api_client")
                .withBaseUrl(url)
                .build()
                .create(Api.class);
    }

    public Map<Long, List<Certificate>> getCertificates(List<Long> uids) {
        FindByUidsRequest request = new FindByUidsRequest();
        request.setUids(uids);
        Result<Map<Long, List<Certificate>>> result = api.findCertificates(request).execute();
        checkResultForErrors(result, ExpertClientException::new);
        return result.getSuccess();
    }

    public List<Certificate> getCertificates(Long uid) {
        return getCertificates(Collections.singletonList(uid)).getOrDefault(uid, emptyList());
    }
}
