package ru.yandex.direct.facebook.graph.client;

import ru.yandex.direct.facebook.graph.client.model.AccessTokenResponse;
import ru.yandex.direct.facebook.graph.client.model.InstagramAccountResponse;
import ru.yandex.direct.facebook.graph.client.model.InstagramIdsResponse;
import ru.yandex.direct.facebook.graph.client.model.InstagramMediaResponse;
import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Path;
import ru.yandex.direct.http.smart.http.Query;

public interface FacebookApi {

    @GET("/oauth/access_token")
    @Json
    Call<AccessTokenResponse> getAccessToken(
            @Query("client_id") String appId,
            @Query("client_secret") String appSecret,
            @Query("redirect_uri") String redirectUri,
            @Query("code") String authCode
    );

    @GET("/me/accounts?fields=instagram_business_account")
    @Json
    Call<InstagramIdsResponse> getInstagramIds(@Query("access_token") String accessToken);

    @GET("/{id}?fields=biography,name,profile_picture_url,username,website")
    @Json
    Call<InstagramAccountResponse> getInstagramAccount(
            @Path("id") String id,
            @Query("access_token") String accessToken
    );

    @GET("/{id}/media?fields=id,caption,media_type,media_url,timestamp")
    @Json
    Call<InstagramMediaResponse> getInstagramMedia(
            @Path("id") String id,
            @Query("access_token") String accessToken,
            @Query("limit") Long limit,
            @Query("after") String after
    );

}
