package ru.yandex.direct.facebook.graph.client;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.facebook.graph.client.model.AccessTokenResponse;
import ru.yandex.direct.facebook.graph.client.model.InstagramAccountResponse;
import ru.yandex.direct.facebook.graph.client.model.InstagramIdsResponse;
import ru.yandex.direct.facebook.graph.client.model.InstagramMediaResponse;
import ru.yandex.direct.http.smart.core.Smart;

import static ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors;

public class FacebookGraphClient {

    private final FacebookApi facebookApi;
    private final FacebookGraphConfiguration configuration;

    public FacebookGraphClient(
            FacebookGraphConfiguration configuration,
            ParallelFetcherFactory parallelFetcherFactory
    ) {
        facebookApi = Smart.builder()
                .withParallelFetcherFactory(parallelFetcherFactory)
                .withProfileName("facebook_api")
                .withBaseUrl(configuration.getFacebookApiUri())
                .build()
                .create(FacebookApi.class);

        this.configuration = configuration;
    }

    public FacebookGraphConfiguration getConfiguration() {
        return configuration;
    }

    public AccessTokenResponse getAccessToken(String authCode) {
        var call = facebookApi.getAccessToken(
                configuration.getAppId(),
                configuration.getAppSecret(),
                configuration.getRedirectUri(),
                authCode
        );
        var result = call.execute();
        checkResultForErrors(result, FacebookApiException::new);
        return result.getSuccess();
    }

    public InstagramIdsResponse getInstagramIds(String accessToken) {
        var call = facebookApi.getInstagramIds(accessToken);
        var result = call.execute();
        checkResultForErrors(result, FacebookApiException::new);
        return result.getSuccess();
    }

    public InstagramAccountResponse getInstagramAccount(String id, String accessToken) {
        var call = facebookApi.getInstagramAccount(id, accessToken);
        var result = call.execute();
        checkResultForErrors(result, FacebookApiException::new);
        return result.getSuccess();
    }

    public InstagramMediaResponse getInstagramMedia(String id, String accessToken, Long limit, String after) {
        var call = facebookApi.getInstagramMedia(id, accessToken, limit, after);
        var result = call.execute();
        checkResultForErrors(result, InstagramApiException::new);
        return result.getSuccess();
    }

}
