package ru.yandex.direct.facebook.graph.client;

public class FacebookGraphConfiguration {

    private final String facebookApiUrl;
    private final String facebookAuthUrl;
    private final int apiVersion;
    private final String appId;
    private final String appSecret;
    private final String redirectUri;
    private final String redirectParams;

    public FacebookGraphConfiguration(
            String facebookApiUrl,
            String facebookAuthUrl,
            int apiVersion,
            String appId,
            String appSecret,
            String redirectUri,
            String redirectParams
    ) {
        this.facebookApiUrl = facebookApiUrl;
        this.facebookAuthUrl = facebookAuthUrl;
        this.apiVersion = apiVersion;
        this.appId = appId;
        this.appSecret = appSecret;
        this.redirectUri = redirectUri;
        this.redirectParams = redirectParams;
    }

    public String getFacebookApiUri() {
        return facebookApiUrl + "/" + getApiVersionSuffix();
    }

    public String getFacebookAuthUri() {
        return facebookAuthUrl + "/" + getApiVersionSuffix();
    }

    public String getApiVersionSuffix() {
        return "v" + apiVersion + ".0";
    }

    public String getAppId() {
        return appId;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public String getRedirectUri() {
        return redirectUri;
    }

    public String getRedirectParams() {
        return redirectParams;
    }
}
