package ru.yandex.direct.facebook.graph.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstagramAccountResponse {
    public String username;
    public String name;
    public String biography;
    public String website;
    public String profilePictureUrl;

    public InstagramAccountResponse withUsername(String username) {
        this.username = username;
        return this;
    }

    public InstagramAccountResponse withName(String name) {
        this.name = name;
        return this;
    }

    public InstagramAccountResponse withBiography(String biography) {
        this.biography = biography;
        return this;
    }

    public InstagramAccountResponse withWebsite(String website) {
        this.website = website;
        return this;
    }

    public InstagramAccountResponse withProfilePictureUrl(String profilePictureUrl) {
        this.profilePictureUrl = profilePictureUrl;
        return this;
    }
}
