package ru.yandex.direct.facebook.graph.client.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonIgnoreProperties(ignoreUnknown = true)
public class InstagramIdsResponse {
    public List<Item> data;
    public Paging paging;

    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Item {
        private InstagramBusinessAccount instagramBusinessAccount;

        public InstagramBusinessAccount getInstagramBusinessAccount() {
            return instagramBusinessAccount;
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static class InstagramBusinessAccount {
            public String id;
        }
    }

}
