package ru.yandex.direct.facebook.graph.client.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonIgnoreProperties(ignoreUnknown = true)
public class InstagramMediaResponse {
    public List<Item> data;
    public Paging paging;

    public InstagramMediaResponse withData(List<Item> data) {
        this.data = data;
        return this;
    }

    public InstagramMediaResponse withPaging(Paging paging) {
        this.paging = paging;
        return this;
    }

    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Item {
        public String id;
        public String mediaType;
        public String caption;
        public String mediaUrl;
        public String timestamp;

        public Item withId(String id) {
            this.id = id;
            return this;
        }

        public Item withMediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Item withCaption(String caption) {
            this.caption = caption;
            return this;
        }

        public Item withMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public Item withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }
    }

}
