package ru.yandex.direct.gemini

import ru.yandex.direct.gemini.model.GeminiResponse
import ru.yandex.direct.http.smart.annotations.Json
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.http.GET
import ru.yandex.direct.http.smart.http.Query

interface GeminiApi {

    companion object {
        private const val NORMAL_KV_REPORT = "yes"
        private const val SP_META_SEARCH = "multi_proxy"
        private const val META_SEARCH = "first_found"
        private const val SAAS_NO_TEXT_SPLIT = "yes"

        private const val BASIC_SAAS_PARAMS = "normal_kv_report=$NORMAL_KV_REPORT&" +
            "sp_meta_search=$SP_META_SEARCH&" +
            "meta_search=$META_SEARCH&" +
            "saas_no_text_split=$SAAS_NO_TEXT_SPLIT"

        private const val HR = "json"
    }

    /**
     * Запрос в сервис gemini, для получения главного урла для переданного урла, в соответствии с типом канонизации
     * https://wiki.yandex-team.ru/robot/gemini/
     */
    @GET("/gemini?$BASIC_SAAS_PARAMS&hr=$HR")
    @Json
    fun getCanonizedUrl(@Query("gemini_user") user: String,
                        @Query("text") urls: Collection<String>,
                        @Query("gemini_type") type: String): Call<GeminiResponse>

}
