package ru.yandex.direct.gemini.model

import com.fasterxml.jackson.annotation.JsonProperty

data class GeminiResponse(
    @JsonProperty("TotalDocCount") val totalDocCount: List<Int>,
    @JsonProperty("Grouping") val grouping: List<GroupingElement>?
) {
    data class GroupingElement(
        @JsonProperty("Group") val group: List<GroupElement>
    )

    data class GroupElement(
        @JsonProperty("Document") val document: List<DocumentElement>
    )

    data class DocumentElement(
        @JsonProperty("ArchiveInfo") val archiveInfo: ArchiveInfo,
        @JsonProperty("Url") val url: String
    )

    data class ArchiveInfo(
        @JsonProperty("GtaRelatedAttribute") val gtaRelatedAttributes: List<GtaRelatedAttribute>
    )

    data class GtaRelatedAttribute(
        @JsonProperty("Key") val key: String,
        @JsonProperty("Value") val value: String
    )
}
