package ru.yandex.direct.geosearch;

import java.util.Collection;

import yandex.maps.proto.common2.response.ResponseOuterClass;

import ru.yandex.direct.http.smart.annotations.ResponseHandler;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Headers;
import ru.yandex.direct.http.smart.http.Query;

interface Api {

    String MS = "pb";
    String TYPE_GEO = "geo";
    String TYPE_BIZ = "biz";
    String HR = "yes"; //нужно добавить чтобы получить человеко-читаемый формат
    String GEOCODER_KIND_METRO = "metro";
    String SPN = "0.5,0.5";

    String MODE_REVERSE = "reverse";
    String SPN_REVERSE = "0.005,0.005";

    String CONTENT_TYPE_HEADER = "Content-Type: application/protobuf";
    String CLUSTER_PERMALINKS = "cluster_permalinks";

    @GET("/yandsearch?ms=" + MS + "&type=" + TYPE_GEO)
    @Headers(CONTENT_TYPE_HEADER)
    @ResponseHandler(parserClass = GeosearchResponseConverter.class, expectedCodes = {200, 204})
    Call<ResponseOuterClass.Response> searchAddress(
            @Query("text") String text, @Query("lang") String lang, @Query("origin") String origin);

    @GET("/yandsearch?ms=" + MS + "&type=" + TYPE_GEO + "&geocoder_kind=" + GEOCODER_KIND_METRO + "&spn=" + SPN)
    @Headers(CONTENT_TYPE_HEADER)
    @ResponseHandler(parserClass = GeosearchResponseConverter.class, expectedCodes = {200, 204})
    Call<ResponseOuterClass.Response> searchMetro(
            @Query("text") String text, @Query("lang") String lang, @Query("origin") String origin);

    @GET("/yandsearch?ms=" + MS + "&type=" + TYPE_GEO + "&mode=" + MODE_REVERSE + "&spn=" + SPN_REVERSE)
    @Headers(CONTENT_TYPE_HEADER)
    @ResponseHandler(parserClass = GeosearchResponseConverter.class, expectedCodes = {200, 204})
    Call<ResponseOuterClass.Response> searchReverse(
            @Query("ll") String coordinates, @Query("geocoder_kind") String kind,
            @Query("lang") String lang, @Query("origin") String origin);

    /**
     * Запрос в геопоиск для получения склеенных пермалинков (дублей организаций Справочника).
     * <p/>
     * Параметры запроса взяты из кода Справочника <br>
     * https://a.yandex-team.ru/arc/trunk/arcadia/sprav/java/libs/geosearch/src/main/java/ru/yandex/geosearch/PbGeoSearchClientImpl.java?rev=5636101#L209
     * <p/>
     * По поводу их значений лучше всего спрашивать саппорт-чат геопоиска, документации на них нет.
     */
    @GET("/yandsearch?ms=" + MS + "&type=" + TYPE_BIZ +
            "&middle_postfilter_disabled=1" +
            "&snippets=online_snippets/1.x" +
            "&rearrs=scheme_Local/Geo/MainSnippets/Sources/SNIPPET_FRESHNESS/Disable=0" +
            "&always_fresh_coords=1" +
            "&gta=" + CLUSTER_PERMALINKS)
    @Headers(CONTENT_TYPE_HEADER)
    @ResponseHandler(parserClass = GeosearchResponseConverter.class, expectedCodes = {200, 204})
    Call<ResponseOuterClass.Response> searchOldPermalinks(@Query("origin") String origin,
                                                          @Query("business_oid") Collection<String> permalinks);
}
