package ru.yandex.direct.geosearch;

import java.time.Duration;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public class GeosearchClientSettings {
    private final int requestRetries;
    private final Duration requestTimeout;
    private final int parallel;
    private final String apiUrl;
    private final String origin;
    private final int tvmAppId;

    public GeosearchClientSettings(String apiUrl, @Nullable String origin, int requestRetries,
                                  Duration requestTimeout, int parallel, int tvmAppId) {
        checkNotNull(apiUrl);
        checkNotNull(requestTimeout);
        checkArgument(requestRetries >= 0);
        checkArgument(parallel > 0);
        checkArgument(tvmAppId > 0);

        this.apiUrl = apiUrl;
        this.origin = origin;
        this.requestRetries = requestRetries;
        this.requestTimeout = requestTimeout;
        this.parallel = parallel;
        this.tvmAppId = tvmAppId;
    }

    public int getRequestRetries() {
        return requestRetries;
    }

    public Duration getRequestTimeout() {
        return requestTimeout;
    }

    public int getParallel() {
        return parallel;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public String getOrigin() {
        return origin;
    }

    public int getTvmAppId() {
        return tvmAppId;
    }
}
