package ru.yandex.direct.geosearch;

import java.lang.reflect.Type;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import org.asynchttpclient.Response;
import yandex.maps.proto.common2.response.ResponseOuterClass;
import yandex.maps.proto.search.business.Business;
import yandex.maps.proto.search.experimental.Experimental;
import yandex.maps.proto.search.geocoder.Geocoder;
import yandex.maps.proto.search.geocoder_internal.GeocoderInternal;
import yandex.maps.proto.search.search.Search;
import yandex.maps.proto.uri.Uri;

import ru.yandex.direct.http.smart.converter.ResponseConverter;

public class GeosearchResponseConverter implements ResponseConverter<ResponseOuterClass.Response> {

    private static ExtensionRegistry getRegistry(){
        ExtensionRegistry registry = ExtensionRegistry.newInstance();
        registry.add(Geocoder.gEOOBJECTMETADATA);
        registry.add(Geocoder.rESPONSEMETADATA);
        registry.add(GeocoderInternal.tOPONYMINFO);
        registry.add(GeocoderInternal.rESPONSEINFO);
        registry.add(Uri.gEOOBJECTMETADATA);
        registry.add(Search.sEARCHMETADATA);
        registry.add(Search.sEARCHRESPONSEMETADATA);
        registry.add(Experimental.gEOOBJECTMETADATA);
        registry.add(Experimental.rESPONSEMETADATA);
        registry.add(Business.gEOOBJECTMETADATA);
        registry.add(Business.rESPONSEMETADATA);
        return registry;
    }

    private static final ExtensionRegistry registry = getRegistry();

    @Override
    public ResponseOuterClass.Response convert(Response response, Type responseType) {
        if (response.getStatusCode() == 204) {
            return ResponseOuterClass.Response.getDefaultInstance();
        }
        ResponseOuterClass.Response resp;
        try {
            resp = ResponseOuterClass.Response.parseFrom(response.getResponseBodyAsByteBuffer(), registry);
        } catch (InvalidProtocolBufferException e) {
            throw new GeosearchClientException("Cannot deserialize Response", e);
        }

        return resp;
    }
}
