package ru.yandex.direct.geosearch.model;

import com.google.common.base.Objects;

public class Address {
    private String country;
    private String city;
    private String street;
    private String house;
    private String building;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address) o;
        return Objects.equal(country, address.country) &&
                Objects.equal(city, address.city) &&
                Objects.equal(street, address.street) &&
                Objects.equal(house, address.house) &&
                Objects.equal(building, address.building);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(country, city, street, house, building);
    }

    /**
     * Вернуть объект в строковом представлении для запроса в геокодер
     *
     * @return строка с адресом
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();

        if (country != null) {
            builder.append(country).append(" ");
        }
        if (city != null) {
            builder.append(city).append(" ");
        }
        if (street != null) {
            builder.append(street).append(" ");
        }
        if (house != null) {
            builder.append(house).append(" ");
        }
        if (building != null) {
            builder.append(building).append(" ");
        }

        return builder.toString().trim();
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getHouse() {
        return house;
    }

    public void setHouse(String house) {
        this.house = house;
    }

    public String getBuilding() {
        return building;
    }

    public void setBuilding(String building) {
        this.building = building;
    }

    public Address withCountry(final String country) {
        this.country = country;
        return this;
    }

    public Address withCity(final String city) {
        this.city = city;
        return this;
    }

    public Address withStreet(final String street) {
        this.street = street;
        return this;
    }

    public Address withHouse(final String house) {
        this.house = house;
        return this;
    }

    public Address withBuilding(final String building) {
        this.building = building;
        return this;
    }
}
