package ru.yandex.direct.geosearch.model;

import java.util.Objects;

public class AddressComponent {

    private final Kind kind;
    private final String name;

    public AddressComponent(Kind kind, String name) {
        this.kind = kind;
        this.name = name;
    }

    public Kind getKind() {
        return kind;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AddressComponent that = (AddressComponent) o;
        return kind == that.kind &&
                Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(kind, name);
    }

    @Override
    public String toString() {
        return "AddressComponent{" +
                "kind=" + kind +
                ", name='" + name + '\'' +
                '}';
    }
}
