package ru.yandex.direct.geosearch.model;

import java.util.Map;

import static com.google.common.base.Preconditions.checkNotNull;
import static java.util.Arrays.asList;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

public enum Kind {

    HOUSE("house"),
    STREET("street"),
    METRO("metro"),
    DISTRICT("district"),
    LOCALITY("locality"),
    AREA(null),
    PROVINCE(null),
    COUNTRY(null),
    HYDRO(null),
    RAILWAY(null),
    ROUTE(null),
    VEGETATION(null),
    OTHER(null),
    UNKNOWN(null), // set this type if parsed text cannot convert to other
    @Deprecated CEMETERY(null),
    @Deprecated BRIDGE(null),
    @Deprecated KM(null);

    private final String queryParameterValue;

    Kind(String queryParameterValue) {
        this.queryParameterValue = queryParameterValue;
    }

    public String getQueryParameterValue() {
        checkNotNull(queryParameterValue, "This type of kind cannot be used as query parameter");
        return queryParameterValue;
    }

    private static Map<String, Kind> enums = listToMap(asList(values()), k -> k.name().toLowerCase());

    public static Kind fromJsonValue(String value) {
        return enums.getOrDefault(value, UNKNOWN);
    }
}

