package ru.yandex.direct.geosearch.model;

public enum Lang {
    RU("ru", "RU"),
    UA("uk", "UA"),
    EN("en", "RU"),
    TR("tr", "TR");

    private final String language;

    private final String country;

    Lang(String language, String country) {
        this.language = language;
        this.country = country;
    }

    public String getLanguage() {
        return language;
    }

    public String getCountry() {
        return country;
    }

    public String getLocale() {
        return language + '_' + country;
    }

}
