package ru.yandex.direct.geosearch.model;

import java.util.Map;

import static java.util.Arrays.asList;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

public enum Precision {
    EXACT(1),
    NUMBER(2),
    NEAR(3),
    STREET(4),
    OTHER(5),
    UNKNOWN(6); // set this type if parsed text cannot convert to other enums

    private static Map<String, Precision> enums = listToMap(asList(values()), e -> e.name().toLowerCase());

    private final int order;

    Precision(int order) {
        this.order = order;
    }

    public int getOrder() {
        return order;
    }

    public static Precision fromJsonValue(String value) {
        return enums.getOrDefault(value, UNKNOWN);
    }
}
