package ru.yandex.direct.graphite;

import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.CharMatcher;

@ParametersAreNonnullByDefault
public class GraphiteUtils {
    private static final char STUB = '_';
    private static final CharMatcher INCORRECT_SYMBOLS =
            CharMatcher.inRange('a', 'z')
                    .or(CharMatcher.inRange('A', 'Z'))
                    .or(CharMatcher.inRange('0', '9'))
                    .or(CharMatcher.anyOf("_-"))
                    .negate();

    static final Pattern METRIC_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-]+(\\.[a-zA-Z0-9_\\-]+)+$");

    private GraphiteUtils() {
    }

    /**
     * Нормализует строку для последующего объединения в качестве составной части полного имени метрики
     *
     * @param metricPart - строка с частью имени метрики
     * @return нормализованное строка
     */
    public static String normalizeMetricPart(String metricPart) {
        if (metricPart.isEmpty()) {
            return String.valueOf(STUB);
        } else {
            return INCORRECT_SYMBOLS.replaceFrom(metricPart, STUB);
        }
    }
}
