package ru.yandex.direct.grid.schemagen.configuration;

import java.util.ArrayList;
import java.util.List;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.grid.core.configuration.GridCoreConfiguration;
import ru.yandex.direct.mysql.ytsync.configuration.B2YtSpringConfiguration;
import ru.yandex.direct.mysql.ytsync.synchronizator.tables.Table;
import ru.yandex.direct.web.configuration.DirectWebConfiguration;

@Configuration
@ComponentScan(
        basePackages = {
                "ru.yandex.direct.grid.schemagen.sqlgen"
        },
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
@Import({
        CoreConfiguration.class,
        GridCoreConfiguration.class,
        B2YtSpringConfiguration.class,
        DirectWebConfiguration.class,
})
public class GridSchemaGenConfiguration {
    @Bean
    public List<Table> tables(ApplicationContext applicationContext) {
        return new ArrayList<>(applicationContext.getBeansOfType(Table.class).values());
    }
}
