package ru.yandex.direct.grid.schemagen.sqlgen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Iterables;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;
import ru.yandex.yt.ytclient.tables.ColumnSchema;
import ru.yandex.yt.ytclient.tables.TableSchema;

import static ru.yandex.direct.grid.schemagen.util.YtUtil.mysqlTypeOf;

@Component
@ParametersAreNonnullByDefault
public class TableSqlGenerator {
    private final List<TaskProvider> taskProviders;

    @Autowired
    public TableSqlGenerator(List<TaskProvider> taskProviders) {
        this.taskProviders = taskProviders;
    }

    public Map<String, String> getSchemas(String postfix, DirectYtSyncConfig config) {
        return StreamEx.of(taskProviders)
                .mapToEntry(t -> getTableSchema(t, postfix, config).trim())
                .mapKeys(t -> getTableName(t, postfix, config))
                .toMap((k1, k2) -> k1);
    }

    private static String getTableSchema(TaskProvider taskProvider, String postfix, DirectYtSyncConfig config) {
        TableSchema schema = taskProvider.getSyncTask().getTableSchema();
        String tableName = getTableName(taskProvider, postfix, config);

        return getTableSchema(schema, tableName);
    }

    public static String getTableSchema(TableSchema schema, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(tableName).append(" (\n");

        List<String> columns = new ArrayList<>();
        for (ColumnSchema columnSchema : schema.getColumns()) {
            columns.add("  " + columnSchema.getName() + " " + mysqlTypeOf(columnSchema.getType()));
        }
        sb.append(String.join(",\n", columns));
        sb.append("\n);\n");

        return sb.toString();
    }

    private static String getTableName(TaskProvider taskProvider, String postfix, DirectYtSyncConfig config) {
        String name = Iterables.getLast(Arrays.asList(taskProvider.getSyncTask().getTablePath(config).split("/")));
        return String.format("%stable_%s", name, postfix);
    }

}
