package ru.yandex.direct.grid.schemagen.util;

import ru.yandex.yt.ytclient.tables.ColumnValueType;

public class YtUtil {
    private YtUtil() {
    }

    public static String mysqlTypeOf(ColumnValueType columnValueType) {
        switch (columnValueType) {
            case INT64:
                return "bigint(20)";
            case UINT64:
                return "bigint(20) unsigned";
            case STRING:
            case ANY:
                return "text";
            case DOUBLE:
                return "decimal(16,6)";
            case BOOLEAN:
                return "tinyint(1)";
            default:
                throw new IllegalStateException("Unsupported type");
        }
    }

    public static String mysqlTypeOf(String type) {
        switch (type) {
            case "timestamp":
            case "date":
            case "int64":
            case "int32":
            case "int16":
            case "int8":
            case "uint32":
            case "uint16":
            case "uint8":
                return "bigint(20)";
            case "uint64":
                return "bigint(20) unsigned";
            case "string":
            case "any":
            case "utf8":
                return "text";
            case "double":
                return "decimal(16,6)";
            case "boolean":
                return "tinyint(1)";
            default:
                throw new IllegalStateException("Unsupported type " + type);
        }
    }
}
