package ru.yandex.direct.hourglass.ydb.storage;

import java.time.Instant;
import java.util.List;

import ru.yandex.direct.ydb.column.Column;
import ru.yandex.direct.ydb.table.Table;

import static com.yandex.ydb.table.values.PrimitiveType.bool;
import static com.yandex.ydb.table.values.PrimitiveType.datetime;
import static com.yandex.ydb.table.values.PrimitiveType.utf8;

@SuppressWarnings({"all"})
public class ScheduledTasks extends Table {
    private static final String TABLE_NAME = "scheduled_tasks";

    public final Column<String> ID = new Column<String>(this, "id", utf8()).pk();
    public final Column<String> NAME = new Column<>(this, "name", utf8());
    public final Column<String> PARAMS = new Column<>(this, "params", utf8());
    public final Column<String> SCHEDULE_HASH = new Column<>(this, "schedule_hash", utf8());
    public final Column<String> STATUS = new Column<>(this, "status", utf8());
    public final Column<String> INSTANCE_ID = new Column<>(this, "instance_id", utf8());
    public final Column<String> VERSION = new Column<>(this, "version", utf8());
    public final Column<Boolean> NEED_RESCHEDULE = new Column<>(this, "need_reschedule", bool());
    public final Column<Instant> HEARTBEAT_TIME = new Column<>(this, "heartbeat_time", datetime());
    public final Column<Instant> NEXT_RUN = new Column<>(this, "next_run", datetime());
    public final Column<Instant> LAST_START_TIME = new Column<>(this, "last_start_time", datetime());
    public final Column<Instant> LAST_FINISH_TIME = new Column<>(this, "last_finish_time", datetime());
    public final Column<String> META = new Column<>(this, "meta", utf8());

    private final List<Column> COLUMNS =
            List.of(ID, NAME, PARAMS, SCHEDULE_HASH, STATUS, INSTANCE_ID, VERSION, NEED_RESCHEDULE, HEARTBEAT_TIME,
                    NEXT_RUN, LAST_START_TIME, LAST_FINISH_TIME, META);

    public ScheduledTasks() {
        super(TABLE_NAME);
    }

    private ScheduledTasks(String alias) {
        super(TABLE_NAME, alias);
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
