package ru.yandex.direct.hourglass.ydb.storage;

import java.time.Instant;
import java.util.List;

import ru.yandex.direct.ydb.column.Column;
import ru.yandex.direct.ydb.table.Table;

import static com.yandex.ydb.table.values.PrimitiveType.bool;
import static com.yandex.ydb.table.values.PrimitiveType.datetime;
import static com.yandex.ydb.table.values.PrimitiveType.utf8;

@SuppressWarnings({"all"})
public class SchedulerInstances extends Table {
    private static final String TABLE_NAME = "scheduler_instances";

    public final Column<String> INSTANCE_ID = new Column<String>(this, "instance_id", utf8()).pk();
    public final Column<String> VERSION = new Column<>(this, "version", utf8());

    public final Column<Boolean> IS_MAIN = new Column<>(this, "is_main", bool());

    public final Column<Instant> HEARTBEAT_TIME = new Column<>(this, "heartbeat_time", datetime());

    public final Column<String> META = new Column<>(this, "meta", utf8());

    private final List<Column> COLUMNS = List.of(INSTANCE_ID, VERSION, IS_MAIN, HEARTBEAT_TIME, META);


    public SchedulerInstances() {
        super(TABLE_NAME);
    }

    private SchedulerInstances(String alias) {
        super(TABLE_NAME, alias);
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }
}
