package ru.yandex.direct.hourglass.ydb.storage;

import java.util.Objects;

import ru.yandex.direct.hourglass.storage.PrimaryId;

public class YdbPrimaryId implements PrimaryId {
    private String id;

    public YdbPrimaryId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YdbPrimaryId that = (YdbPrimaryId) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return id;
    }
}
