package ru.yandex.direct.hourglass;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public interface TaskThreadPool {

    int activeThreadsCount();

    int availableThreadCount();

    void shutdown();

    int getPoolSize();

    /**
     * @throws RejectedExecutionException если невозможно запустить задачу
     */
    default Future<Void> start(Callable<Void> main) {
        AtomicReference<Future<Void>> futureHolder = new AtomicReference<>();
        execute(futureHolder::set, main);
        return futureHolder.get();
    }

    /**
     * Аналогично {@link #start(Callable)}, но позволяет получить доступ к feature до начала ее выполнения
     */
    void execute(Consumer<Future<Void>> futureConsumer, Callable<Void> main);

    boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException;
}
