package ru.yandex.direct.hourglass.client;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;

import ru.yandex.direct.hourglass.storage.Job;

public interface HourglassClient {
    Collection<Job> getTasks();

    List<SchedulerInstance> getSchedulers();

    void changeNextRunTime(Job job, Instant at, ZoneOffset zoneOffset);

    void pauseTask(Job job);

    void continueTask(Job job);
}
