package ru.yandex.direct.hourglass.implementations;

import java.util.Objects;
import java.util.UUID;

import ru.yandex.direct.hourglass.InstanceId;

public class InstanceIdImpl implements InstanceId {
    private final String value;

    public InstanceIdImpl() {
        this(UUID.randomUUID().toString());
    }

    public InstanceIdImpl(String value) {
        this.value = value;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InstanceIdImpl that = (InstanceIdImpl) o;
        return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        return value;
    }
}
