package ru.yandex.direct.hourglass.implementations;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Hash {
    private final ThreadLocal<MessageDigest> instance;

    public MD5Hash() {
        instance = ThreadLocal.withInitial(() -> {
                    try {
                        return MessageDigest.getInstance("SHA-256");
                    } catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                }
        );
    }

    private long padToLong(byte[] bytes) {
        long retVal = (bytes[0] & 0xFF);
        for (int i = 1; i < Math.min(bytes.length, 8); i++) {
            retVal |= (bytes[i] & 0xFFL) << (i * 8);
        }
        return retVal;
    }

    public long hash(String key) {
        MessageDigest messageDigest = instance.get();
        messageDigest.reset();
        messageDigest.update(key.getBytes());

        return padToLong(messageDigest.digest());
    }
}
