package ru.yandex.direct.hourglass.implementations;

import javax.annotation.PostConstruct;

import ru.yandex.direct.hourglass.InstanceId;
import ru.yandex.direct.hourglass.InstanceMeta;
import ru.yandex.direct.hourglass.MonitoringWriter;
import ru.yandex.direct.hourglass.SchedulerInstancePinger;
import ru.yandex.direct.hourglass.updateschedule.SchedulerInstancesRepository;

public class SchedulerInstancePingerImpl implements SchedulerInstancePinger, AutoCloseable {
    private final SchedulerInstancesRepository schedulerInstancesRepository;
    private final InstanceId instanceId;
    private final String version;
    private final InstanceMeta instanceMeta;
    private final MonitoringWriter monitoringWriter;

    public SchedulerInstancePingerImpl(InstanceId instanceId, String version,
                                       SchedulerInstancesRepository schedulerInstancesRepository,
                                       InstanceMeta instanceMeta,
                                       MonitoringWriter monitoringWriter
    ) {
        this.instanceId = instanceId;
        this.schedulerInstancesRepository = schedulerInstancesRepository;
        this.instanceMeta = instanceMeta;
        this.version = version;
        this.monitoringWriter = monitoringWriter;
    }

    @PostConstruct
    public void init() {
        this.schedulerInstancesRepository.addInstance(instanceId, version, instanceMeta);
    }

    @Override
    public void ping() {
        schedulerInstancesRepository.pingInstance(instanceId);
        monitoringWriter.schedulerPinged();
    }

    @Override
    public void close() {
        schedulerInstancesRepository.removeInstance(instanceId);
    }
}
